/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.network;

import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import mods.flammpfeil.slashblade.capability.slashblade.ComboState;
import mods.flammpfeil.slashblade.event.BladeMotionEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class MotionBroadcastMessage {
    public UUID playerId;
    public String combo;

    public static MotionBroadcastMessage decode(FriendlyByteBuf buf) {
        MotionBroadcastMessage msg = new MotionBroadcastMessage();
        msg.playerId = buf.m_130259_();
        msg.combo = buf.m_130277_();
        return msg;
    }

    public static void encode(MotionBroadcastMessage msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.playerId);
        buf.m_130070_(msg.combo);
    }

    public static void handle(MotionBroadcastMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().setPacketHandled(true);
        if (ctx.get().getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            return;
        }
        BiConsumer handler = (BiConsumer)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> MotionBroadcastMessage::setPoint);
        if (handler != null) {
            ctx.get().enqueueWork(() -> handler.accept(msg.playerId, msg.combo));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setPoint(UUID playerId, String combo) {
        Player target = Minecraft.m_91087_().f_91073_.m_46003_(playerId);
        if (target == null) {
            return;
        }
        if (!(target instanceof AbstractClientPlayer)) {
            return;
        }
        ComboState state = (ComboState)ComboState.NONE.valueOf(combo);
        if (state == null) {
            return;
        }
        MinecraftForge.EVENT_BUS.post((Event)new BladeMotionEvent((LivingEntity)target, state));
    }
}

